<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\OtherUserAssetsService;
use Illuminate\Http\Request;

class OtherUserAssetsController extends Controller
{
    /**
     * Constructor for OtherUserAssetsController.
     *
     * @param OtherUserAssetsService $serviceClass The service class used to manage user assets.
     */
    public function __construct(protected OtherUserAssetsService $serviceClass) {}

    /**
     * take the assets of the given email user
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function index(Request $request)
    {
        $data = $this->serviceClass->getOtherUserAssets($request);

        return response()->json($data);
    }
}
