<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\MyAssetsService;
use Illuminate\Http\Request;

class MyAssetsController extends Controller
{
    /**
     * Constructor for MyAssetsController.
     *
     * @param MyAssetsService $serviceClass The service class used to manage user assets.
     */
    public function __construct(protected MyAssetsService $serviceClass) {}

    /**
     * take the assets of the given email user
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function index(Request $request)
    {
        $data = $this->serviceClass->getAssets($request);

        return response()->json($data);
    }


    /**
     * Take the asset details by asset tag for the given user
     */
    // public function searchByAssetTag(Request $request)
    // {
    //     $data = $this->serviceClass->searchAssetByAssetTag($request);

    //     return response()->json($data);
    // }

}
