<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\LoanerReturnDateService;
use Illuminate\Http\Request;

class LoanerReturnDateController extends Controller
{
    public function __construct(LoanerReturnDateService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    /**
     * Get Asset Details for '/tq extend loaner Asset#' command
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getAssetToUpdate(Request $request)
    {   
        $data = $this->serviceClass->getAssetToUpdate($request);

        return response()->json($data);
    }

    /**
     * Update the Expected Return Date
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function updateLoanerReturnDate(Request $request)
    {   
        $data = $this->serviceClass->updateReturnDate($request);

        return response()->json($data);
    }

}