<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\InstallAssetService;
use Illuminate\Http\Request;
use Log;

class InstallAssetController extends Controller
{
    public function __construct(InstallAssetService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    /**
     * Get Asset Details for '/assign <serial number> <user email>' command
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getAssetDetails(Request $request)
    {   
        $data = $this->serviceClass->getAssetDetails($request);

        return response()->json($data);
    }

    /**
     * Update the asset status to "Assign"
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function updateAssetStatus(Request $request)
    {   
        return $this->serviceClass->updateAssetStatus($request);
    }

}