<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\AssignAssetService;
use Illuminate\Http\Request;
use Log;

class AssignAssetController extends Controller
{
    public function __construct(AssignAssetService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    /**
     * Get Asset Details for '/assign <serial number> <user email>' command
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getAssetDetails(Request $request)
    {   
        Log::info('Request got from the slack app');
        $data = $this->serviceClass->getAssetDetails($request);

        return response()->json($data);
    }

    /**
     * Update the asset status to "Assign"
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function updateAssetStatus(Request $request)
    {   
        return $this->serviceClass->updateAssetStatus($request);
    }

}