<?php

namespace App\Http\Controllers\Api\Slackbot;

use App\Http\Controllers\Controller;
use App\Services\Api\Slackbot\AssetTagService;
use Illuminate\Http\Request;

class AssetTagController extends Controller
{
    public function __construct(AssetTagService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    /**
     * Get Asset Details for '/tq update asset tag Asset#' command
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getAssetToUpdate(Request $request)
    {   
        $data = $this->serviceClass->getAssetToUpdate($request);

        return response()->json($data);
    }

    /**
     * Update Asset Tag
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function updateAssetTag(Request $request)
    {   
        $data = $this->serviceClass->updateAssetTag($request);

        return response()->json($data);
    }

}