<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\SiteCodeApiService;

/**
 * Controller class for Site Code API
 */
class SiteCodeApiController extends Controller
{
    /**
     * @var SiteCodeApiService
     */
    protected $siteCodeApiService;

    /**
     * Create a new SiteCodeApiController instance.
     *
     * @param SiteCodeApiService $siteCodeApiService
     */
    public function __construct(SiteCodeApiService $siteCodeApiService)
    {
        $this->siteCodeApiService = $siteCodeApiService;
    }

    /**
     * Get all site codes.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $siteCodes = $this->siteCodeApiService->getSiteCodes($request);

        if ($siteCodes->count() == 0) {
            return $this->siteCodeApiService->noResultResponse('Site Code not found');
        }

        return $this->siteCodeApiService->successResponse($siteCodes);
    }
}
