<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\MobileCarrierApiService;

/**
 * Controller class for MobileCarrier API
 */
class MobileCarrierApiController extends Controller
{
    /**
     * @var MobileCarrierApiService
     */
    protected $mobileCarrierApiService;

    /**
     * Create a new MobileCarrierApiController instance.
     *
     * @param MobileCarrierApiService $mobileCarrierApiService
     */
    public function __construct(MobileCarrierApiService $mobileCarrierApiService)
    {
        $this->mobileCarrierApiService = $mobileCarrierApiService;
    }

    /**
     * Get all mobile carriers.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $carriers = $this->mobileCarrierApiService->getMobileCarriers($request);

        if ($carriers->count() == 0) {
            return $this->mobileCarrierApiService->noResultResponse('Mobile Carrier not found');
        }

        return $this->mobileCarrierApiService->successResponse($carriers);
    }
}
