<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\Mdm\Intune\DeviceNotCreated as IntuneDeviceNotCreated;
use App\Http\Controllers\Api\Mdm\Jamf\DeviceNotCreated as JamfDeviceNotCreated;
use App\Http\Controllers\Api\Mdm\ChromeBook\DeviceNotCreated as ChromeBookDeviceNotCreated;
use App\Http\Controllers\Api\Mdm\Kandji\DeviceNotCreated as KandjiDeviceNotCreated;
use App\Http\Controllers\Api\Mdm\MobileIron\DeviceNotCreated as MobileIronDeviceNotCreated;
use App\Http\Controllers\Api\Mdm\WorkspaceOne\DeviceNotCreated as WorkspaceOneDeviceNotCreated;
use App\Services\Api\ApiService;

/**
 * Controller class for Mobile Device Management (MDM) API.
 */
class MdmController extends Controller
{
    /**
     * @var ApiService
     */
	protected $apiService;

	/**
     * Create a new MdmController instance.
     *
     * @param ApiService $apiService
     */
	public function __construct(ApiService $apiService)
	{
		$this->apiService = $apiService;
	}

    /**
     * Get device information for a specific MDM.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $mdmName = $request->query('mdm_name');

        switch ($mdmName) {
            case 'intune':
                return app()->make(IntuneDeviceNotCreated::class)->index($request);
                break;
            case 'jamf':
                return app()->make(JamfDeviceNotCreated::class)->index($request);
                break;
            case 'chrome-devices':
                return app()->make(ChromeBookDeviceNotCreated::class)->index($request);
                break;
            case 'kandji':
                return app()->make(KandjiDeviceNotCreated::class)->index($request);
                break;
            case 'mobile-iron':
                return app()->make(MobileIronDeviceNotCreated::class)->index($request);
                break;
            case 'workspaceone':
                return app()->make(WorkspaceOneDeviceNotCreated::class)->index($request);
                break;
            default:
                return $this->apiService->noResultResponse('Invalid MDM Name');
        }
    }
}
