<?php

namespace App\Http\Controllers\Api\Mdm\MobileIron;

use App\Http\Controllers\Controller;
use App\Services\Api\DiscoveryTools\MobileIronApiService;
use Illuminate\Http\Request;

class DeviceNotCreated extends Controller
{
    protected $mobileIronApiService;

    public function __construct(MobileIronApiService $mobileIronApiService)
    {
        $this->mobileIronApiService = $mobileIronApiService;
    }

    /**
     * return list of mobile iron devices those are not present in the system
     *
     * @return [type]
     */
    public function index(Request $request)
    {
        $devicesNotCreated = $this->mobileIronApiService->getDevicesNotCreated($request);

        if ($devicesNotCreated->count() == 0) {
            return $this->mobileIronApiService->errorResponse('No data available');
        }

        return $this->mobileIronApiService->successResponse($devicesNotCreated);
    }
}
