<?php

namespace App\Http\Controllers\Api\Mdm\Kandji;

use App\Http\Controllers\Controller;
use App\Services\Api\DiscoveryTools\KandjiApiService;
use Illuminate\Http\Request;

class DeviceNotCreated extends Controller
{
    protected $kandjiApiService;

    public function __construct(KandjiApiService $kandjiApiService)
    {
        $this->kandjiApiService = $kandjiApiService;
    }

    /**
     * return list of Intune devices those are not present in the system
     *
     * @return [type]
     */
    public function index(Request $request)
    {
        $devicesNotCreated = $this->kandjiApiService->getDevicesNotCreated($request);

        if ($devicesNotCreated->count() == 0) {
            return $this->kandjiApiService->errorResponse('No data available');
        }

        return $this->kandjiApiService->successResponse($devicesNotCreated);
    }
}
