<?php

namespace App\Http\Controllers\Api\Mdm\Jamf;

use App\Http\Controllers\Controller;
use App\Services\Api\DiscoveryTools\JamfApiService;
use Illuminate\Http\Request;

class DeviceNotCreated extends Controller
{
    protected $jamfApiService;

    public function __construct(JamfApiService $jamfApiService)
    {
        $this->jamfApiService = $jamfApiService;
    }

    /**
     * return list of Intune devices those are not present in the system
     *
     * @return [type]
     */
    public function index(Request $request)
    {
        $devicesNotCreated = $this->jamfApiService->getDevicesNotCreated($request);

        if ($devicesNotCreated->count() == 0) {
            return $this->jamfApiService->errorResponse('No data available');
        }

        return $this->jamfApiService->successResponse($devicesNotCreated);
    }
}
