<?php

namespace App\Http\Controllers\Api\Mdm\Intune;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Api\DiscoveryTools\IntuneApiService;

class DeviceNotCreated extends Controller
{
    protected $intuneApiService;

    public function __construct(IntuneApiService $intuneApiService)
    {
        $this->intuneApiService = $intuneApiService;
    }

    /**
     * return list of Intune devices those are not present in the system
     * 
     * @return [type]
     */    
    public function index(Request $request)
    {
        $devicesNotCreated = $this->intuneApiService->getDevicesNotCreated($request);

        if ($devicesNotCreated->count() == 0) {
            return $this->intuneApiService->errorResponse('No data available');
        }

        return $this->intuneApiService->successResponse($devicesNotCreated);
    }
}
