<?php

namespace App\Http\Controllers\Api\Mdm\ChromeBook;

use App\Http\Controllers\Controller;
use App\Services\Api\DiscoveryTools\ChromeBookApiService;
use Illuminate\Http\Request;

class DeviceNotCreated extends Controller
{
    protected $chromeBookApiService;

    public function __construct(ChromeBookApiService $chromeBookApiService)
    {
        $this->chromeBookApiService = $chromeBookApiService;
    }

    /**
     * return list of Intune devices those are not present in the system
     *
     * @return [type]
     */
    public function index(Request $request)
    {
        $devicesNotCreated = $this->chromeBookApiService->getDevicesNotCreated($request);

        if ($devicesNotCreated->count() == 0) {
            return $this->chromeBookApiService->errorResponse('No data available');
        }

        return $this->chromeBookApiService->successResponse($devicesNotCreated);
    }
}
