<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\ManufacturerApiService;

/**
 * Controller class for Asset Type API
 */
class ManufacturerApiController extends Controller
{
    /**
     * @var ManufacturerApiService
     */
    protected $manufacturerApiService;

    /**
     * Constructor to initialize the ManufacturerApiController.
     *
     * @param ManufacturerApiService $manufacturerApiService
     */
    public function __construct(ManufacturerApiService $manufacturerApiService)
    {
        $this->manufacturerApiService = $manufacturerApiService;
    }

    /**
     * Get all manufacturers.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        if ($this->manufacturerApiService->checkDataLimit($request->limit)) {
            return $this->manufacturerApiService->limitExceededResponse();
        }

        $manufacturers = $this->manufacturerApiService->getManufacturers($request);

        if ($manufacturers->count() == 0) {
            return $this->manufacturerApiService->noResultResponse('Manufacturers not found');
        }

        return $this->manufacturerApiService->successResponse($manufacturers);
    }
}
