<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\LocationTypeApiService;

/**
 * Controller class for Location Type API
 */
class LocationTypeApiController extends Controller
{
    /**
     * @var LocationTypeApiService
     */
    protected $locationTypeApiService;

    /**
     * Constructor to initialize the LocationTypeApiController.
     *
     * @param LocationTypeApiService $locationTypeApiService
     */
    public function __construct(LocationTypeApiService $locationTypeApiService)
    {
        $this->locationTypeApiService = $locationTypeApiService;
    }

    /**
     * Get all location types.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $locationTypes = $this->locationTypeApiService->getLocationTypes($request);

        if ($locationTypes->count() == 0) {
            return $this->locationTypeApiService->noResultResponse('Location Type not found');
        }

        return $this->locationTypeApiService->successResponse($locationTypes);
    }
}
