<?php

namespace App\Http\Controllers\Api\Jira;

use App\Services\Api\ApiService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Exception;
use DB;

/**
 * this class is used to search the users for status update user drop down from jira App
 */
class TeqtivityUsersSearchController extends controller
{

	public function index(Request $request)
	{
		try {
			if (request('search')) {
				$search = $request->search;
				$res = User::superAdmin()->select('id', 'first_name', 'last_name', 'email')
					->where(function ($query) use ($search) {
						$query->where('first_name', 'like', $search . '%')
							->orWhere('last_name', 'like', $search . '%')
							->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) like ?", [$search . '%'])
							->orWhere('email', 'like', $search . '%');
					})
					->limit(10)->get();

				$result = $res->mapWithKeys(function ($item, $key) {
					return [
						$key => [
							'id'    => $item->id,
							'type'  => 'user',
							'value' => $item->email,
							'text' => $item->first_name . ' ' . $item->last_name . ' - ' . $item->email,
						],
					];
				});
				return $result;
			}
		} catch (Exception $e) {
			//nothing
		}

		return null;
	}
}
