<?php

namespace App\Http\Controllers\Api\Jira;

use App\Services\Api\ApiService;
use App\Http\Controllers\Controller;
use App\User;
use Exception;

/**
 * Controller class for Teqtivity Users
 */
class TeqtivityUsersController extends controller
{
    public function __construct(ApiService $responseService)
    {
        $this->responseService = $responseService;
    }

    public function index()
    {
        try {
            $users =  User::superAdmin()
                ->select(['id', 'first_name', 'last_name', 'email'])
                ->get();

            return  $this->responseService->successResponse($users, 'Users');
        } catch (Exception $e) {
            return $this->responseService->errorResponse('Something went wrong. Try again later');
        }
    }

    /**
     * Find the user by email addres
     *
     * @param string $email
     */
    public function findByEmail($email)
    {
        try {
            $user =  User::where('email', $email)->first();
            if ($user) {
                return  $this->responseService->successResponse($user, 'User');
            }
        } catch (Exception $e) {
            //nothing
        }

        return $this->responseService->errorResponse('User not found');
    }
}
