<?php

namespace App\Http\Controllers\Api\Jira;

use App\Services\Api\ApiService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Location;
use Exception;
use DB;

/**
 * this class is used to search the locations for status update user drop down from jira App
 */
class TeqtivityLocationsSearchController extends controller
{

	public function index(Request $request)
	{
		try {
			if (request('search')) {
				$search = $request->search;
				$res    = Location::select(['id', 'room_name'])
					->where('room_name', 'like', $search . '%')
					->limit(10)->get();

				$result = $res->mapWithKeys(function ($item, $key) {
					return [
						$key => [
							'id'    => $item->id,
							'type'  => 'Location',
							'value' => $item->room_name,
							'text' => $item->room_name
						],
					];
				});
				return $result;
			}
		} catch (Exception $e) {
			//nothing
		}

		return null;
	}
}
