<?php

namespace App\Http\Controllers\Api\Jira;

use App\Http\Controllers\Controller;
use App\Services\Api\ApiService;
use App\Models\Location;
use Exception;

/**
 * Controller class for Teqtivity Locations
 */
class TeqtivityLocationsController extends controller
{
	public function __construct(ApiService $responseService)
	{
		$this->responseService = $responseService;
	}

	/**
	 * All location List
	 */
	public function index()
	{
		try {
			$locations = Location::select(['id', 'room_name'])->get();

			return $this->responseService->successResponse($locations, 'Locations');
		} catch (Exception $e) {
			return $this->responseService->successResponse('Something went wrong. Try again later');
		}
	}
}
