<?php

namespace App\Http\Controllers\Api\Jira;

use App\Services\Api\ApiService;
use App\Http\Controllers\Controller;
use App\Models\AssetStatus;
use Exception;
use Illuminate\Support\Facades\Log;

/**
 * Controller class for asset status details
 */
class TeqtivityAssetStatusDetailsController extends controller
{

	public function __construct(protected ApiService $responseService)
	{
	}


	/**
	 * Display the specified asset status.
	 *
	 * @return \Illuminate\Http\JsonResponse The JSON response containing the asset status or an error message.
	 */
	public function index()
	{
		try {
			$assetStatus = AssetStatus::where('name', request('status'))->first();

			return $this->responseService->successResponse($assetStatus, 'AssetStatus');
		} catch (Exception $e) {
			Log::channel('single')->info("Jira Plugin Status Details Error: " . $e->getMessage());

			return $this->responseService->errorResponse('Something went wrong. Try again later');
		}
	}
}
