<?php

namespace App\Http\Controllers\Api\Jira;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\ApiService;
use App\Services\Api\Jira\TeqtivityAssetStatus;
use Exception;
use Illuminate\Support\Facades\Log;

/**
 * 
 */
class TeqtivityAssetStatusController extends controller
{

	public function __construct(protected TeqtivityAssetStatus $statusService, protected ApiService $responseService)
	{
	}

	public function update(Request $request)
	{
		$error = $this->statusService->validate($request);
		if ($error) {
			return $this->responseService->errorResponse($error);
		}
		try {
			$response = $this->statusService->update($request);

			return $this->responseService->successResponse('', $response);
		} catch (Exception $e) {
			Log::channel('single')->info('Jira Plugin Status Update Error : ' . $e->getMessage());
			return $this->responseService->errorResponse('Something went wrong. Try again later');
		}
	}
}
