<?php

namespace App\Http\Controllers\Api\Jira;

use App\Http\Controllers\Controller;
use App\Services\Api\Jira\ReporterAssets;

class ReporterAssetsController extends Controller
{
    public function __construct(ReporterAssets $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }

    /**
     * take the assets of the given email user
     *
     * @param string $email
     *
     * @return Collection
     */
    public function index($email)
    {
        $data = $this->serviceClass->getAssets($email);

        return response()->json($data);
    }

}
