<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\UserCreateApiService;

class CreateUserApiController extends Controller
{
    /**
     * The UserCreateApiService instance.
     *
     * @var UserCreateApiService
     */
    protected $userCreateApiService;

    /**
     * Create a new controller instance.
     *
     * @param UserCreateApiService $userCreateApiService
     */
    public function __construct(UserCreateApiService $userCreateApiService)
    {
        $this->userCreateApiService = $userCreateApiService;
    }

    /**
     * Handle the user creation request.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
    	$errors = $this->userCreateApiService->validateFields();

    	if($errors) {
	        return $this->userCreateApiService->validateErrorResponse($errors);
    	}

    	$userData = $this->userCreateApiService->getData();

        $this->userCreateApiService->saveData($userData);

        return $this->userCreateApiService->successResponse([], 'Created User');
    }
}
