<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\LocationCreateApiService;

class CreateLocationApiController extends Controller
{
    /**
     * The LocationCreateApiService instance.
     *
     * @var LocationCreateApiService
     */
    protected $locationCreateApiService;

    /**
     * Create a new controller instance.
     *
     * @param LocationCreateApiService $locationCreateApiService
     */
    public function __construct(LocationCreateApiService $locationCreateApiService)
    {
        $this->locationCreateApiService = $locationCreateApiService;
    }

    /**
     * Handle the location creation request.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
    	$errors = $this->locationCreateApiService->validateFields();

    	if($errors) {
	        return $this->locationCreateApiService->validateErrorResponse($errors);
    	}

    	$locationData = $this->locationCreateApiService->getData();

        $this->locationCreateApiService->saveData($locationData);

        return $this->locationCreateApiService->successResponse([], 'Created Location');
    }
}
