<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\Api\AssetCreateApiService;

class CreateAssetApiController extends Controller
{
    /**
     * The AssetCreateApiService instance.
     *
     * @var AssetCreateApiService
     */
    protected $assetCreateApiService;

    /**
     * Create a new controller instance.
     *
     * @param AssetCreateApiService $assetCreateApiService
     */
    public function __construct(AssetCreateApiService $assetCreateApiService)
    {
        $this->assetCreateApiService = $assetCreateApiService;
    }

    /**
     * Handle the asset creation request.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
    	$errors = $this->assetCreateApiService->validateFields();

    	if($errors) {
	        return $this->assetCreateApiService->validateErrorResponse($errors);
    	}

    	$assetData = $this->assetCreateApiService->getData();

        if ($assetData === false) {
            return $this->assetCreateApiService->errorResponse('Invalid combination of Asset type - Manufacturer - Hardware Standard - Technical Spec');
        }

        $this->assetCreateApiService->saveData($assetData);

        return $this->assetCreateApiService->successResponse([], 'Created Asset');
    }
}
