<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\AssetTypesApiService;

/**
 * Controller class for Asset Type API
 */
class AssetTypesApiController extends Controller
{

    /**
     * @var AssetTypesApiService
     */
    protected $assetTypesApiService;

    /**
     * Create a new controller instance.
     *
     * @param AssetTypesApiService $assetTypesApiService
     */
    public function __construct(AssetTypesApiService $assetTypesApiService)
    {
        $this->assetTypesApiService = $assetTypesApiService;
    }

    /**
     * Get all asset types.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAssetTypes(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $assetTypes = $this->assetTypesApiService->getAssetTypes($request);

        if ($assetTypes->count() == 0) {
            return $this->assetTypesApiService->noResultResponse('Asset Types not found');
        }

        return $this->assetTypesApiService->successResponse($assetTypes);
    }
}
