<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Api\AssetStatusApiService;

/**
 * Controller class for Asset Status API
 */
class AssetStatusApiController extends Controller
{

    /**
     * @var AssetStatusApiService
     */
    protected $assetStatusApiService;

    /**
     * Create a new controller instance.
     *
     * @param AssetStatusApiService $assetStatusApiService
     */
    public function __construct(AssetStatusApiService $assetStatusApiService)
    {
        $this->assetStatusApiService = $assetStatusApiService;
    }

    /**
     * Get all asset statuses.
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $request->validate([
            'search' => ['nullable', 'regex:/^[a-z0-9,@. _-]+$/i']
        ]);

        $statuses = $this->assetStatusApiService->getAssetStatus($request);

        if ($statuses->count() == 0) {
            return $this->assetStatusApiService->noResultResponse('Asset status not found');
        }

        return $this->assetStatusApiService->successResponse($statuses);
    }
}
