<?php

namespace App\Exports;

use App\Models\AssetHealthTests;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithBatchInserts;

class AssetHealthTestReport implements FromView, WithTitle, WithBatchInserts
{
    /**
     * Constructs a new instance of the class.
     *
     * @return void
     */
    public function __construct(
        protected AssetHealthTests $assetHealthTest,
        protected mixed $testReportData
    ) {
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->assetHealthTest->test_name ?? 'Asset Health Test';
    }


    public function view(): View
    {
        return view('exports.asset-health.tests', [
            'testReportData' => $this->testReportData,
            'testData' => $this->assetHealthTest
        ]);
    }

    public function batchSize(): int
    {
        return 1000;
    }
}
