<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithBatchInserts;

class AssetHealthReport implements WithMultipleSheets, WithBatchInserts
{
    use Exportable;

    /**
     * Constructs a new instance of the class.
     *
     * @return void
     */
    public function __construct(
        protected array $testReports,
        protected array $testDetailsReports
    ) {
    }

    public function sheets(): array
    {
        $sheets = [];


        foreach ($this->testReports as $categoryReport) {

            $category = $categoryReport['category'];
            $testReport = $categoryReport['tests'];

            $sheets[] = new AssetHealthCategoryReport($category, $testReport);

        }

        foreach ($this->testDetailsReports as $testReport) {
            $test = $testReport['test'];
            $testDetailReport = $testReport['reports'];

            $sheets[] = new AssetHealthTestReport($test, $testDetailReport);
        }

        return $sheets;
    }

    public function batchSize(): int
    {
        return 1000;
    }
}
