<?php

namespace App\Exports;

use App\Models\AssetHealthCategory;
use App\Models\AssetHealthReports;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class AssetHealthCategoryReport implements FromView, WithTitle
{
    /**
     * Constructs a new instance of the class.
     *
     * @return void
     */
    public function __construct(
        protected AssetHealthCategory $assetHealthCategory,
        protected mixed $testReportData
    ) {
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->assetHealthCategory->category_name ?? 'Asset Health Category';
    }


    public function view(): View
    {
        return view('exports.asset-health.category', [
            'testReportData' => $this->testReportData
        ]);
    }
}
