<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class UpdateAssetStatus
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $description, $ticketId, $assetHistory, $userId;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($description, $ticketId, $assetHistory, $userId)
    {
        $this->description = $description;
        $this->ticketId = $ticketId;
        $this->assetHistory = $assetHistory;
        $this->userId = $userId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
