<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class IntegrationSyncHistory
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public $syncLog;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($syncName, $syncStatus = 1, $notes ='' )
    {
        $this->syncLog  = array(
         'sync_name' =>$syncName,
         'notes' =>$notes,
         'sync_status' =>$syncStatus
        );
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
