<?php

namespace App\Constants;

class AssetStatus
{
    public const ASSIGNED                = "Assigned";
    public const ASSIGNEDSLUG            = "assigned";

    public const BRANDNEW                = "Brand New";
    public const BRANDNEWSLUG            = "brand_new";

    public const DAMAGED                 = "Damaged";
    public const DAMAGEDSLUG             = "damaged";

    public const ENDOFLIFE               = "End of Life";
    public const ENDOFLIFESLUG           = "end_of_life";

    public const ENDOFLIFEDISPOSED       = "End of Life Disposed";
    public const ENDOFLIFEDISPOSEDSLUG   = "end_of_life_disposed";

    public const INSTALLED               = "Installed";
    public const INSTALLEDSLUG           = "installed";

    public const LEGALHOLD               = "Legal Hold";
    public const LEGALHOLDSLUG           = "legal_hold";

    public const LIKENEW                 = "Like New";
    public const LIKENEWSLUG             = "like_new";

    public const LOANED                  = "Loaned";
    public const LOANEDSLUG              = "loaned";

    public const LOSTORSTOLEN            = "Lost or Stolen";
    public const LOSTORSTOLENSLUG        = "lost_or_stolen";

    public const RMARETURNEDTOVENDOR     = "RMA Returned to Vendor";
    public const RMARETURNEDTOVENDORSLUG = "rma_returned";

    public const RETAINHOLD              = "Retain Hold";
    public const RETAINHOLDSLUG          = "retain_hold";

    public const USED                    = "Used";
    public const USEDSLUG                = "used";

    public const USEDLOANER              = "Used Loaner";
    public const USEDLOANERSLUG          = "used_loaner";

    public const CDWINTRANSIT            = "CDW In Transit";
    public const CDWINTRANSITSLUG        = "cdw_in_transit";

    public const EOLDATAWIPED            = "EOL Data Wiped";
    public const EOLDATAWIPEDSLUG        = "eol_data_wiped";

    public const SHIINTRANSIT            = "SHI In Transit";
    public const SHIINTRANSITSLUG        = "shi_in_transit";

    public const INSIGHTINTRANSIT        = "Insight In Transit";
    public const INSIGHTINTRANSITSLUG    = "insight_in_transit";

    public const CONNECTIONINTRANSIT     = "Connection In Transit";
    public const CONNECTIONINTRANSITSLUG = "connection_in_transit";

    public const STATUSES                = [
        [
            'name'                       => self::ASSIGNED,
            'slug'                       => self::ASSIGNEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 0,
            'can_be_linked'              => 1,
            'can_be_returned'            => 1,
        ],
        [
            'name'                       => self::BRANDNEW,
            'slug'                       => self::BRANDNEWSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 1,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::DAMAGED,
            'slug'                       => self::DAMAGEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::ENDOFLIFE,
            'slug'                       => self::ENDOFLIFESLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::ENDOFLIFEDISPOSED,
            'slug'                       => self::ENDOFLIFEDISPOSEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::INSTALLED,
            'slug'                       => self::INSTALLEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 1,
            'can_be_linked'              => 1,
            'can_be_returned'            => 1,
        ],
        [
            'name'                       => self::LEGALHOLD,
            'slug'                       => self::LEGALHOLDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::LIKENEW,
            'slug'                       => self::LIKENEWSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 1,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::LOANED,
            'slug'                       => self::LOANEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 0,
            'can_be_linked'              => 1,
            'can_be_returned'            => 1,
        ],
        [
            'name'                       => self::LOSTORSTOLEN,
            'slug'                       => self::LOSTORSTOLENSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 1,
        ],
        [
            'name'                       => self::RMARETURNEDTOVENDOR,
            'slug'                       => self::RMARETURNEDTOVENDORSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::RETAINHOLD,
            'slug'                       => self::RETAINHOLDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 1,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::USED,
            'slug'                       => self::USEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 1,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::USEDLOANER,
            'slug'                       => self::USEDLOANERSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 1,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::CDWINTRANSIT,
            'slug'                       => self::CDWINTRANSITSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 1,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::EOLDATAWIPED,
            'slug'                       => self::EOLDATAWIPEDSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::SHIINTRANSIT,
            'slug'                       => self::SHIINTRANSITSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::INSIGHTINTRANSIT,
            'slug'                       => self::INSIGHTINTRANSITSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
        [
            'name'                       => self::CONNECTIONINTRANSIT,
            'slug'                       => self::CONNECTIONINTRANSITSLUG,
            'can_be_assigned'            => 0,
            'has_user'                   => 0,
            'has_location'               => 0,
            'can_be_linked'              => 0,
            'can_be_returned'            => 0,
        ],
    ];

    public const INSTOCKSTATUSES = [self::BRANDNEWSLUG, self::LIKENEWSLUG, self::USEDSLUG, self::LOSTORSTOLENSLUG];
}
