<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Carbon\Carbon;

class Kernel extends ConsoleKernel
{
        /**
         * The Artisan commands provided by your application.
         *
         * @var array
         */
        protected $commands = [
                '\App\Console\Commands\ActiveAdminLog',
                '\App\Console\Commands\RefreshNotification',
                '\App\Console\Commands\InternalAdminReport',
                '\App\Console\Commands\LoanerItemDueTomorrow',
                '\App\Console\Commands\LoanerItemOverDueYesterday',
                '\App\Console\Commands\LoanerItemDueWeek',
                '\App\Console\Commands\LeaseEndDateToday',
                '\App\Console\Commands\LeaseEndDateNextWeek',
                '\App\Console\Commands\DamagedItems',
                '\App\Console\Commands\LoanerItemOverDueMonth',
                '\App\Console\Commands\IntransitLocation',
                '\App\Console\Commands\DeleteDuplicateUsers',
                '\App\Console\Commands\IntuneDataSync',
                '\App\Console\Commands\JamfDataSync',
                '\App\Console\Commands\OktaDirectory',
                '\App\Console\Commands\OktaDirectorySpecificRange',
                '\App\Console\Commands\CdwUpload',
                '\App\Console\Commands\CdwUploadAll',
                '\App\Console\Commands\NewHireJiraSync',
                '\App\Console\Commands\OnetimeRunnable',
                '\App\Console\Commands\AssetTrackingSync',
                '\App\Console\Commands\ChromebookSync',
                '\App\Console\Commands\RevokeExpiredTokens',
                '\App\Console\Commands\SubscriptionExpiryNotification',
                '\App\Console\Commands\WorkspaceOneUpload',
                '\App\Console\Commands\KandjiSync',
                '\App\Console\Commands\MobileIronUpload',
                '\App\Console\Commands\LastStatusUpdateSync',
                '\App\Console\Commands\DropboxSync',
                '\App\Console\Commands\ShiImport',
                '\App\Console\Commands\InsightUpload',
                '\App\Console\Commands\InsightUploadAll',
                '\App\Console\Commands\ConnectionUpload',
                '\App\Console\Commands\ConnectionUploadAll',
                '\App\Console\Commands\TQT195DeleteAssets',
                '\App\Console\Commands\TQT195MixupAssets',
                '\App\Console\Commands\TQT195UpdateUsers',
                '\App\Console\Commands\TQT195DiscoveryTools',
                '\App\Console\Commands\TQT195SoftwareAssets',
                '\App\Console\Commands\CleanUpStorage',
                '\App\Console\Commands\ApiCredentialsOnetimeRunnable',
                '\App\Console\Commands\SlackSync',
                '\App\Console\Commands\ZoomSync',
                '\App\Console\Commands\ActiveUserCountInLastTwelveMonths',
                '\App\Console\Commands\EOLWipedCheckingInAssetsCountUpdate',
                '\App\Console\Commands\CrowdstrikeSync',
                '\App\Console\Commands\CopyTableContents',
                '\App\Console\Commands\RemoveUnwantedTables',
                '\App\Console\Commands\NewHiresWithZeroAssets',
                '\App\Console\Commands\TerminatedUsersStillAssignedToAssets',
                '\App\Console\Commands\ActiveVulnerabilitiesCountPerWeek',
                'App\Console\Commands\AwsCloudAssetsSync',
                '\App\Console\Commands\AssetHealthReport',
                '\App\Console\Commands\RetrieverDataSync',
                '\App\Console\Commands\RevivnDataSync',
                '\App\Console\Commands\LoanerItemOverDueAdminNotification',
                '\App\Console\Commands\LoanerItemDueNextWeekUserNotification',
                '\App\Console\Commands\GoogleDirectoryUsersSync',
                '\App\Console\Commands\GsuiteLocationsSync',
                '\App\Console\Commands\PresidioImport',
                '\App\Console\Commands\HiBobUserImport',
                '\App\Console\Commands\ZoomHardwareDataSync',
        ];

        /**
         * Define the application's command schedule.
         *
         * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
         * @return void
         */
        protected function schedule(Schedule $schedule)
        {
                //active admin log
                $first = Carbon::today()->startOfMonth();
                $endDay = $first->copy()->endOfMonth()->format('d');

                $schedule->command('ActiveAdminLog:activeadminlog')
                        ->monthlyOn(1, '00:00');
                $schedule->command('ActiveAdminLog:activeadminlog')
                        ->monthlyOn($endDay, '23:59');

                //internal admin report
                $schedule->command('InternalAdminReport:internaladminreport')
                        ->monthlyOn(1, '00:00');

                //refresh notification
                $schedule->command('RefreshNotification:refreshnotification')->everySixHours();

                //Revoke Expired Token
                $schedule->command('revoke:expiredTokens')
                        ->dailyAt('01:00');
                //Subscription overdue notification
                $schedule->command('SubscriptionExpiryNotification')
                        ->dailyAt('04:00');
                //Storage clean up
                // $schedule->command('storage:cleanUpFiles')
                //         ->dailyAt('02:00');
                $schedule->command('ActiveUserCountInLastTwelveMonths:update')
                        ->weeklyOn(1, '06:30');

                $schedule->command('EOLWipedCheckingInAssetsCount:update')
                        ->dailyAt('08:00');

                // Fetch data from Intune.
                $schedule->command('IntuneDataSync:run')
                        ->dailyAt('02:00');

                //Fetch assets from Presidio API
                $schedule->command('presidio:import')
                        ->dailyAt('03:30');

                // Loaner Item Overdue Admin Notification
                $schedule->command('LoanerItemOverDueAdmin:notify')->dailyAt('07:00');

                // Loaner Item Due Next Week User Notification
                $schedule->command('LoanerItemDueNextWeekUser:notify')->dailyAt('08:00');

                // HiBob User Import Every 6 hours
                $schedule->command('HiBobUser:import')->everySixHours();

                // Zoom Hardware Data Sync Every Day at 4 AM
                $schedule->command('zoomHardwareDataSync:run')->dailyAt('04:00');
        }

        /**
         * Register the commands for the application.
         *
         * @return void
         */
        protected function commands()
        {
                require_once base_path('routes/console.php');
        }
}
