<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Department;
use App\Models\EmployeePosition;
use App\Models\EmployeeType;
use App\User;
use Carbon\Carbon;

class TQT195UpdateUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Updateusers:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update users on TQT-195';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        $departmentDesignations = [
            'Sales Group'                                   => ['Sales Manager', 'Account Executive', 'Sales Development Representative', 'Customer Success Manager'],
            'Marketing'                                     => ['Marketing Manager', 'Brand Strategist', 'Content Marketing Specialist', 'Social Media Manager', 'Marketing Analyst'],
            'Accounting and Finance'                        => ['Finance Manager', 'Accountant', 'Financial Analyst', 'Controller'],
            'Human Resource Management'                     => ['Human Resources Manager', 'Recruiter', 'HR Generalist', 'Compensation Analyst', 'Training and Development Specialist'],
            'Production'                                    => ['Production Manager', 'Manufacturing Engineer', 'Quality Control Inspector', 'Production Planner'],
            'Development Operations'                        => ['DevOps Engineer', 'Release Engineer', 'Build Engineer', 'Configuration Manager'],
            'Operations'                                    => ['Operations Manager', 'Business Operations Analyst', 'Supply Chain Analyst', 'Logistics Coordinator'],
            'Legal'                                         => ['General Counsel', 'Paralegal', 'Legal Assistant', 'Contracts Manager'],
            'Contact Center'                                => ['Call Center Manager', 'Customer Service Representative', 'Technical Support Specialist', 'Operations Coordinator'],
            'Software Engineering'                          => ['Software Engineer', 'Full Stack Developer', 'Front-end Developer', 'Back-end Developer', 'Mobile App Developer'],
            'Direct to Consumer'                            => ['E-commerce Manager', 'Merchandising Manager', 'Product Manager', 'Customer Service Manager'],
            'Finance'                                       => ['Financial Planning and Analysis Manager', 'Investment Analyst', 'Budget Analyst', 'Financial Reporting Manager'],
            'Quality Assurance'                             => ['QA Manager', 'Quality Control Specialist', 'Quality Assurance Engineer', 'Test Engineer'],
            'Data Analytics'                                => ['Data Analyst', 'Business Intelligence Analyst', 'Data Scientist', 'Data Engineer'],
            'Enterprise Platform Services'                  => ['Enterprise Architect', 'Infrastructure Engineer', 'Database Administrator', 'Network Engineer'],
            'Information Technology'                        => ['IT Manager', 'System Administrator', 'Network Administrator', 'Technical Support Engineer'],
            'Human Resources'                               => ['Human Resources Director', 'Employee Relations Manager', 'Benefits Specialist', 'HRIS Analyst'],
            'Executives'                                    => ['CEO', 'COO', 'CFO', 'Chief People Officer', 'Chief Strategy Officer'],
            'Operations - Service Delivery'                 => ['Service Delivery Manager', 'Service Desk Analyst', 'Operations Coordinator'],
            'Quality Assurance'                             => ['QA Lead', 'Quality Control Lead', 'Test Lead', 'Quality Assurance Engineer', 'QA Analyst'],
            'Engineering - Data Analytics'                  => ['Data Engineering Manager', 'Data Analyst', 'Data Scientist', 'Machine Learning Engineer'],
            'NOC Support'                                   => ['NOC Manager', 'NOC Engineer', 'Network Administrator', 'System Administrator'],
            'Innovation - Clinical Operations'              => ['Clinical Operations Manager', 'Clinical Data Analyst', 'Clinical Research Coordinator'],
            'Innovation - Engineering'                      => ['Innovation Engineer', 'Innovation Project Manager', 'R&D Engineer'],
            'Innovation - DevOps'                           => ['Innovation DevOps Engineer', 'Innovation Release Manager', 'Innovation Build Engineer'],
            'Information Technology - Information Security' => ['IT Security Manager', 'Security Engineer', 'Security Analyst'],
            'Innovation - Product Management'               => ['Innovation Product Manager', 'Product Owner', 'Product Analyst'],
            'Innovation - Quality Assurance'                => ['Innovation QA Manager', 'Innovation Quality Control Specialist', 'Innovation Test Engineer'],
            'Innovation - Architecture'                     => ['Innovation Architect', 'Enterprise Architect', 'Solution Architect']
        ];


        $cities = [
            'New York', 'Los Angeles', 'Chicago', 'Houston', 'Phoenix', 'Philadelphia', 'San Antonio', 'San Diego',
            'Dallas', 'San Jose', 'Austin', 'Jacksonville', 'Fort Worth', 'Columbus', 'San Francisco', 'Charlotte', 'Indianapolis',
            'Seattle', 'Denver', 'Washington D.C.', 'Boston', 'Nashville', 'El Paso', 'Detroit', 'Memphis'
        ];

        $employeeTypes = ['Full-time', 'Part-time', 'FTE', 'Temporary', 'Contract', 'Intern', 'Consultant', 'Freelancer', 'Seasonal', 'Remote'];

        Department::truncate();
        EmployeePosition::truncate();
        EmployeeType::truncate();

        foreach ($departmentDesignations as $department => $designations) {
            $departmentData = Department::updateOrCreate(
                ['name' => strtolower($department)],
                ['name' => $department]
            );

            foreach ($designations as $designation) {
                EmployeePosition::create([
                    'name' => $designation,
                    'slug' => str_slug($designation, '_'),
                ]);
            }
        }

        foreach ($employeeTypes as $empType) {
            EmployeeType::create([
                'name' => $empType,
                'slug' => str_slug($empType, '_'),
            ]);
        }

        $allUsersCount = User::superAdmin()->count();
        $allDepartments = Department::get();

        $userPerDepartment = intval($allUsersCount / $allDepartments->count());


        $limit = $userPerDepartment; // number of records to retrieve


        for ($i = 0; $i < $allDepartments->count(); $i++) {

            $offset = $limit * $i;

            $users = User::superAdmin()->skip($offset)->take($limit)->get();

            $designations = $departmentDesignations[$allDepartments[$i]->name];

            foreach ($users as $user) {

                $randomKey = array_rand($designations);
                $title = $designations[$randomKey];

                $cityKey = array_rand($cities);
                $city = $cities[$cityKey];
                $user->update([
                    'department_id' => $allDepartments[$i]->id,
                    'position_id' => EmployeePosition::where('name', $title)->first()->id,
                    'employee_type_id' => EmployeeType::inRandomOrder()->first()->id,
                    'business_title' => $title,
                    'city' => $city,
                    'hire_date' => convert_to_db_datetime($this->getStartDate())
                ]);

                // $this->info($allDepartments[$i]->name . ' - ' . $title . ' - ' . $city . ' - ' . $this->getStartDate());
            }
        }
        $this->info("Updated users.");
    }

    public function getStartDate()
    {
        // Get the start and end dates
        $endDate = Carbon::now();
        $startDate = Carbon::now()->subYears(3);

        // Generate a random date within the range, excluding weekends
        do {
            $randomDate = Carbon::createFromTimestamp(rand($startDate->timestamp, $endDate->timestamp));
        } while ($randomDate->isWeekend());

        // Output the date in your desired format
        return $randomDate->format('m/d/Y');
    }
}
