<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Asset;
use App\Models\AssetHistory;
use App\Models\AssetStatus;
use App\Models\AssetType;
use App\Models\MakeAndModel;

class TQT195DeleteAssets extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'DeleteAssets:delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete assets on TQT-195';


    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $percenTageArray = [
            'mifi' => 70,
            'network' => 70,
            'av_audio' => 50,
            'av_video' => 50,
            'av_control' => 50,
            'av_display' => 50,
        ];

        $assetTypes = AssetType::whereIn('slug', ['mifi', 'network', 'av_audio', 'av_video', 'av_control', 'av_display'])->get();
        $assetStatuses = AssetStatus::get();

        foreach ($assetTypes as $assetType) {

            $makeAndModels = MakeAndModel::where('asset_type_id', $assetType->id)->get();

            foreach ($makeAndModels as $makeAndModel) {

                $toBeRemoved = [];
                $totalExist = 0;

                foreach ($assetStatuses as $assetStatus) {

                    $allDevices = Asset::select('id')->where(['asset_type_id' => $assetType->id, 'asset_status_id' => $assetStatus->id, 'make_and_model_id' => $makeAndModel->id])->get();

                    if (is_countable($allDevices) && $allDevices->count() > 0) {

                        $cuttingPercentage = $allDevices->count() > 150 ? ($percenTageArray[$assetType->slug] + 10) : $percenTageArray[$assetType->slug];

                        $percentOfTotal = round(($cuttingPercentage / 100) * $allDevices->count());

                        $totalExist += $allDevices->count();

                        $deviceArray = $allDevices->pluck('id')->toArray();

                        $randomKeys = array_rand($deviceArray, $percentOfTotal);

                        if (is_array($randomKeys)) {
                            $randomValues = array_intersect_key($deviceArray, array_flip($randomKeys));
                            $toBeRemoved = [...$toBeRemoved, ...$randomValues];
                        }
                    }
                }

                AssetHistory::whereIn('asset_id', $toBeRemoved)->delete();
                Asset::whereIn('id', $toBeRemoved)->delete();

                $this->info('Total Assets: '. $totalExist);

                $this->info("Deleted " . count($toBeRemoved) . ' ' . $assetType->name . ' ' . $makeAndModel->name);
            }
        }

        $accessories = Asset::where('asset_type_id', AssetType::where('slug', 'accessories')->first()->id);
        $accessoryCount = $accessories->count();

        $accessories->each(function ($accessory) {
            $accessory->assetHistory()->delete();
        });

        $accessories->delete();

        $this->info($accessoryCount . " Accessories deleted");
    }
}
