<?php

namespace App\Console\Commands;

use App\Models\SoftwareLicense\SoftwareLicense;
use App\Notifications\Slack;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;

class SubscriptionExpiryNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'SubscriptionExpiryNotification:subscriptionexpiry';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Notifications to admin in Slack that a subscription is about to expire.';


    /**
     * Execute the console command for sending notification to admin in Slack that a subscription is about to expire.
     *
     * @return mixed
     */
    public function handle()
    {
        $endingSubscriptions = SoftwareLicense::select('id', 'name', 'renewal_date', 'auto_renewal')->whereIn('renewal_date', config('software-license.notification_period'))->get();

        if (!empty($endingSubscriptions)) {
            foreach ($endingSubscriptions as $endingSubscription) {
                try {
                    Notification::route('slack', config('error-notification-mails.slack'))->notify(new Slack($this->getSoftwareAssetsSubscriptionExpiryMessage($endingSubscription)));
                } catch (\Exception $e) {
                    Log::channel('daily')->info("Slack Notification error: " . $e->getMessage());
                }
            }
        }

        $this->info('Done');
    }

    /**
     * Create Notification to admin in Slack that a subscription is about to expire.
     * @param mixed $license
     *
     * @return [type]
     */
    public function getSoftwareAssetsSubscriptionExpiryMessage($license)
    {
        return $license->name . " subscription will expire on $license->renewal_date. Auto renewal for this subscription is set to " . $license->auto_renewal . ".";
    }
}
