<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Schema;

class RemoveUnwantedTables extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'removeUnwatedTables:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Drops the unused tables from the database';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $tables = [
            'cdw_accessories_mappings', 'cdw_hardware_mappings', 'cdw_unwanted_parts',
            'connection_accessories_mappings', 'connection_hardware_mappings', 'connection_unwanted_parts',
            'insight_accessories_mappings', 'insight_hardware_mappings', 'insight_unwanted_parts',
            'shi_accessories_mappings', 'shi_hardware_mappings', 'shi_unwanted_parts',
            'saved_new_hire_reports', 'saved_termination_reports', 'saved_terms_reports', 'saved_accessories', 'saved_reports',
            'duplicated_assets',
            'variance_report_reminders'
        ];

        foreach ($tables as $table) {
            Schema::dropIfExists($table);
            $this->info($table . ' Dropped.');
        }
    }
}
