<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use App\Events\BulkUpdates;
use App\Models\IntuneComputer;
use App\Repositories\DiscoveryTools\IntuneRepository;

class OnetimeRunnable extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Onetime:fix';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'One time runnable commands for quick fixes / updates on existing data';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(Protected IntuneRepository $intuneRepository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Updating mac addresses');
        
        $updatedAssetNumbers = $this->formatAndStoreAllMacAddresses();

        $this->info("Updated  - $updatedAssetNumbers ");
    }

    public function formatAndStoreAllMacAddresses()
    {
        $updatedCount = 0;

        $intuneAssets = IntuneComputer::whereNotNull('mac_address')->get();

        foreach ($intuneAssets as $intuneAsset) {
            $formatted = $this->intuneRepository->formatMacAddress($intuneAsset->mac_address);

            if ($formatted && $intuneAsset->mac_address !== $formatted) {
                $intuneAsset->mac_address = $formatted;

                $intuneAsset->timestamps = false;

                $intuneAsset->save();
                $updatedCount++;
            }
        }

        return $updatedCount;
    }


   
}
