<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\NewHire\NewHireTicketService;
use App\Models\UserJiraMappings;

class NewHireJiraSync extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'NewHireJiraSync:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync the new hires table with Jira ticket';


    /**
     * Create a new command instance.
     *
     * @param NewHireTicketService $newHireTicketService An instance of NewHireTicketService for managing new hire tickets.
     *
     * @return void
     */
    public function __construct(protected NewHireTicketService $newHireTicketService)
    {
        parent::__construct();
    }


    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $users = $this->newHireTicketService->getNewHireUsers();

        UserJiraMappings::truncate();

        $count = 0;

        foreach ($users as $user) {
            /** Assigned Laptops */
            $assignedUserDetails = $this->newHireTicketService->getAssignedDetailsFromJira($user);
            $this->newHireTicketService->addDetailsToNewHire($assignedUserDetails, $user->id);

            $count++;
        }

        $this->info($count . " users added");
    }
}
