<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\LoanerItemOverDueMonth as LoanerDue;

class LoanerItemOverDueMonth extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LoanerItemOverDueMonth:loaneritemduemonth';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Loaner item over due month admin notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $dateLastMonth = Carbon::now()->subDays(30)->toDateString();
            $assets = Asset::with('user', 'assetType', 'makeAndModel', 'technicalSpec')->hasStatus('loaned')->whereDate('loaner_return_date', '<=', $dateLastMonth)->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new LoanerDue($assets));
            }
        }
    }
}
