<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\LoanerItemDueWeek as LoanerDue;

class LoanerItemDueWeek extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LoanerItemDueWeek:loaneritemdueweek';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Loaner item due on this week notification to admin';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $assets = Asset::with('user', 'assetType', 'makeAndModel', 'technicalSpec')->assetDueWeek()->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new LoanerDue($assets));
            }
        }
    }
}
