<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Asset;
use Illuminate\Support\Facades\Notification;
use App\Notifications\LoanerItemDue;

class LoanerItemDueTomorrow extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LoanerItemDueTomorrow:loaneritemdue';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Loaner item due on tomorrow notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $dateTommorow = Carbon::now()->addDay()->toDateString();
            $assets = Asset::with('user.position', 'user.employeeType', 'assetType', 'makeAndModel', 'technicalSpec')->hasStatus('loaned')->whereDate('loaner_return_date', $dateTommorow)->get();
            if ($assets) {
                foreach ($assets as $asset) {
                    if ($asset->user) {
                        Notification::send($asset->user, new LoanerItemDue($asset));
                    }
                }
            }
        }
    }
}
