<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Asset;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Notification;
use App\Notifications\LeaseEndDateToday as LeaseEnd;

class LeaseEndDateToday extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LeaseEndDateToday:leaseendtoday';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lease end notification to admin';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $assets = Asset::with('location', 'assetType', 'makeAndModel', 'technicalSpec')->whereDate('lease_end_date', Carbon::today()->toDateString())->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new LeaseEnd($assets));
            }
        }
    }
}
