<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Asset;
use Carbon\Carbon;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\LeaseEndDateNextWeek as LeaseEndNextWeek;

class LeaseEndDateNextWeek extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LeaseEndDateNextWeek:leaseenddatenextweek';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lease end next week admin notification  ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $assets = Asset::with('location', 'assetType', 'makeAndModel', 'technicalSpec')->whereDate('lease_end_date', Carbon::today()->addWeek()->toDateString())->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new LeaseEndNextWeek($assets));
            }
        }
    }
}
