<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Asset;
use Carbon\Carbon;
use App\Notifications\LocationIntransit;
use Illuminate\Support\Facades\Notification;

class IntransitLocation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'IntransitLocation:intransitlocation';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Notification email for assets in intransit location';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $assets = Asset::with('assetType', 'makeAndModel', 'technicalSpec')
                ->whereHas('location', function ($query) {
                    $query->where('room_name', 'like', '%TRANSIT%');
                })
                ->whereDate('updated_at', '<=', Carbon::now()->subDays(15)->toDateString())->get();

            if ($assets) {
                Notification::route('mail', $this->adminEmail)->notify(new LocationIntransit($assets));
            }
        }
    }
}
