<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\ActiveAdminUsersLog;
use Illuminate\Support\Facades\Notification;
use App\Notifications\InternalAdminReport as Report;

class InternalAdminReport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'InternalAdminReport:internaladminreport';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Email no of active admin report';

    protected $adminEmail;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->adminEmail = config('mail.teqAdminEmail');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (env('APP_ENV') == 'production') {
            $users = [];
            $start = new Carbon('first day of last month');
            $startDate = $start->format('Y-m-d');

            $end = new Carbon('last day of last month');
            $endDate = $end->format('Y-m-d');

            $users['month'] = $start->format('F');

            $beginUsers = ActiveAdminUsersLog::whereDate('created_at', $startDate)->first();
            $endUsers   = ActiveAdminUsersLog::whereDate('created_at', $endDate)->first();

            $users['usersAtBeginning'] = $beginUsers ? json_decode($beginUsers->no_of_users) : 0;
            $users['usersAtEnd'] = $endUsers ? json_decode($endUsers->no_of_users) : 0;

            $totalBeginCount = 0;
            if ($users['usersAtBeginning'] != NULL) {
                foreach ($users['usersAtBeginning'] as $beginUser) {
                    $totalBeginCount = $totalBeginCount + $beginUser->count;
                }
            }
            $users['totalBeginCount'] = $totalBeginCount;

            $totalEndCount = 0;
            if ($users['usersAtEnd'] != NULL) {
                foreach ($users['usersAtEnd'] as $endUser) {
                    $totalEndCount = $totalEndCount + $endUser->count;
                }
            }
            $users['totalEndCount'] = $totalEndCount;

            Notification::route('mail', $this->adminEmail)->notify(new Report($users));
        }
    }
}
