<?php

namespace App\Console\Commands;

use App\Notifications\Slack;
use Illuminate\Console\Command;
use App\Events\IntegrationSyncHistory;
use Illuminate\Support\Facades\Notification;
use App\Services\Integrations\UserDirectory\HiBobIntegration;

class HiBobUserImport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'HiBobUser:import';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync the users from HiBob user directory';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(protected HiBobIntegration $service)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (!$this->service->ping()) {
            $message = 'FAILED! Connection failed';
            $this->sendNotification($message);

            return $this->info($message);
        }

        $count = $this->service->syncAllUsers();
        $message = 'HiBob users import completed. Total ' . $count . ' users updated';

        event(new IntegrationSyncHistory('hibob'));

        $this->sendNotification($message);

        return $this->info($message);
    }

    /**
     * Send Mail Notification
     *
     * @param bool $status
     */
    public function sendNotification($message)
    {
        if (config('teqtivity-notification-mails.slack')) {
            Notification::route('slack', config('teqtivity-notification-mails.slack'))->notify(new Slack($message));
        }
    }
}
