<?php

namespace App\Console\Commands;

use App\Notifications\Slack;
use App\Services\GoogleWorkspace\GoogleDirectoryService;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;

class GoogleDirectoryUsersSync extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'GoogleDirectoryUsers:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync the google directory users.';

    public function __construct(protected GoogleDirectoryService $service)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $usersCount = 0;
        $client = $this->service->getJwtAccessToken();
        if (!$client) {
            $this->sendNotification('FAILED.Google directory connection failed.');
            return $this->info("Google directory connection failed.");
        }
        try {
            $usersCount  = $this->service->importDirectoryUsers();

            if ($usersCount === null) {
                $this->sendNotification('FAILED.Google directory sync failed.');

                return $this->info("Google directory sync failed.");
            }

            $message = "Google directory sync completed. Total  $usersCount  users added.";
            $this->sendNotification($message);

            return $this->info("Google directory sync completed. Total $usersCount users added.");
        } catch (Exception $e) {
            // dd($e->getMessage(), $e->getLine(), $e->getFile());
            $this->sendNotification('FAILED.Google directory connection failed.');

            return $this->info("Google directory sync failed.");
        }
    }


    /**
     * Send Mail Notification
     *
     * @param mixed $message
     */
    public function sendNotification($message)
    {
        if (config('teqtivity-notification-mails.slack')) {
            Notification::route('slack', config('teqtivity-notification-mails.slack'))->notify(new Slack($message));
        }

        return true;
    }
}
